package gov.va.med.mhv.sm.admin.jpa.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Type;

@Entity
@Table(name = "SMCLINICS_TRIAGE_MAP")
public class SMClinicsTriageMap extends AbstractBaseEntity {

	private static final long serialVersionUID = 8260279225327755310L;

	@Id
	@Column(name = "SMCLINICSTRIAGEMAP_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "TRIAGE_GROUP_ID")
	private Long triageGroupId;

	@Column(name = "SMCLINIC_IEN")
	private Long smClinicIen;
	
	@Column(name = "SMCLINIC_NAME")
	private String smClinicName;
	
	@Column(name = "SMCLINIC_NAME_CPRSTITLE")
	private String smClinicNameCPRSTitle;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getTriageGroupId() {
		return triageGroupId;
	}

	public void setTriageGroupId(Long triageGroupId) {
		this.triageGroupId = triageGroupId;
	}

	public Long getSmClinicIen() {
		return smClinicIen;
	}

	public void setSmClinicIen(Long smClinicIen) {
		this.smClinicIen = smClinicIen;
	}

	public String getSmClinicName() {
		return smClinicName;
	}

	public void setSmClinicName(String smClinicName) {
		this.smClinicName = smClinicName;
	}

	public String getSmClinicNameCPRSTitle() {
		return smClinicNameCPRSTitle;
	}

	public void setSmClinicNameCPRSTitle(String smClinicNameCPRSTitle) {
		this.smClinicNameCPRSTitle = smClinicNameCPRSTitle;
	}
	
}
